#ani_rotation.py
import numpy as np
import matplotlib as mlt
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
T=365          #Umlaufzeit in Tage
w=2*np.pi/T    #Kreisfrequenz
r1,r2=0.5,0.25 #Radien von Sonne und Planet  
a,b=8,4        #Ellipsenachsen
dt = 0.5       #Zeitschrittweite
breite=10
#Bahnberechnung
def bahn(i):
    t = i*dt
    x,y = a*np.cos(w*t),b*np.sin(w*t) 
    planet.set_center([x,y])
    txtZeit.set_text('$t$ = %3.0f d' %t)
    return planet,txtZeit
#Grafikbereich
fig,ax=plt.subplots()
t=np.arange(0,T,dt)
ax.axis([-breite,breite,-breite,breite])
stern = mlt.patches.Circle((2.5,0),radius=r1, color='red')
planet= mlt.patches.Circle((0,0),  radius=r2, color='blue')
ax.add_artist(stern)
ax.add_artist(planet)
txtZeit=ax.text(-2,8.5,'')
ani=FuncAnimation(fig,bahn,frames=t.size,interval=20,blit=True)
ax.set(xlabel='$x$',ylabel='$y$',title='elliptische Umlaufbahn')
ax.set_aspect('equal')
plt.show()


