#funktionsplot.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
a=5     #Beschleunigung m/s^2
v0=20   #Geschwindigkeit in m/s
tmax=10 #Zeitachse in s
#Funktionsdefinitonen
#konstante Geschwindigkeit
def f1(t,v0):
    return 0*t + v0
#beschleunigte Bewegung
def f2(t,v0):
    return a*t + v0
#Grafikbereich
fig, ax = plt.subplots(figsize=(10,8),label='beschleunigte Bewegung')
t=np.linspace(0,tmax,100) #t=np.arange(0,tmax,0.1)
ax.plot(t,f1(t,v0),'b-',label='gleichförmige Bewegung')
ax.plot(t,f2(t,0),'r-',label='beschleunigte Bewegung')
#Beschriftungen
ax.text(8,37,r'$v=a\cdot t$')
ax.set_title('gleichförmige und beschleunigte Bewegung')
ax.set_xlabel('$t$ in s')
ax.set_ylabel('$v$ in m/s')
ax.legend()
fig.show()





