#num_differenzieren.py
import numpy as np
import matplotlib.pyplot as plt
from numdifftools import Derivative
T=1         #Periodendauer
w=2*np.pi/T #Kreisfrequenz
#Sinus-Funktion
def f1(t):
    return np.sin(w*t) 
#erste Ableitung
def f2(t):
    df=Derivative(f1,n=1)
    return df(t)
#Grafikbereich
fig,ax = plt.subplots(2,1)
t = np.linspace(0,T,500) 
ax[0].plot(t, f1(t), 'b-', lw=1.2)
ax[1].plot(t, f2(t), 'r-', lw=1.2)
#Beschriftungen
ax[0].set_ylabel('$y$')
ax[1].set(xlabel='$t$',ylabel=r'$\dot{y}$',title='1. Ableitung')
fig.tight_layout()
plt.show()

'''
#Lösung der Übung
import numpy as np
import matplotlib.pyplot as plt
from numdifftools import Derivative
T=1         #Periodendauer
w=2*np.pi/T #Kreisfrequenz
#Sinus-Funktion
def f1(t):
    return np.sin(w*t) 
#erste Ableitung
def f2(t):
    df=Derivative(f1)
    return df(t)
#zweite Ableitung
def f3(t):
    df=Derivative(f2)
    return df(t)
#Grafikbereich
fig,ax = plt.subplots(3,1)
t = np.linspace(0,T,500) 
ax[0].plot(t, f1(t), 'b-', lw=1.2)
ax[1].plot(t, f2(t), 'r-', lw=1.2)
ax[2].plot(t, f3(t), 'g-', lw=1.2)
#Beschriftungen
ax[0].set_ylabel('$y$')
ax[1].set(xlabel='$t$',ylabel=r'$\dot{y}$',title='1. Ableitung')
fig.tight_layout()
plt.show()
'''
