#02_008.py
#Auflagekräfte
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
l = 10    #Länge des Hebels in m
F=100      #Kraft in  N
#Grafikbereich
fig, ax=plt.subplots()
ax.axis([-0.5,6,-8,8])

ax.plot([0,l],[0,0],'k-',lw=6)
ax.plot(0,0,'rx',markersize=8)
ax.plot([0,0],[-8,10],'k--')
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
#Kraftwvetoren
pfeilFA = FancyArrowPatch((0.5,-5),(0.5,0),color='red',arrowstyle=spitze)
pfeilF1 = FancyArrowPatch((1,5),(1,0),color='red',arrowstyle=spitze)
pfeilF2 = FancyArrowPatch((2,5),(2,0),color='red',arrowstyle=spitze)
pfeilF3 = FancyArrowPatch((3,5),(3,0),color='red',arrowstyle=spitze)
pfeilFB = FancyArrowPatch((5,-5),(5,0),color='red',arrowstyle=spitze)
pfeilX = FancyArrowPatch((0,-7),(6,-7),color='black',arrowstyle=spitze)
ax.add_patch(pfeilFA)
ax.add_patch(pfeilF1)
ax.add_patch(pfeilF2)
ax.add_patch(pfeilF3)
ax.add_patch(pfeilFB)
ax.add_patch(pfeilX)
#Textelemente
ax.text(0.3,-6.0, r'$\vec{F}_{A}, x_{A} $',fontsize='12')
ax.text(4.8,-6.0,r'$\vec{F}_{B}, x_{B} $',fontsize='12')
ax.text(0.8,5.5,r'$\vec{F}_{1}, x_{1}$',fontsize='12')
ax.text(1.8,5.5,r'$\vec{F}_{2}, x_{2}$',fontsize='12')
ax.text(2.8,5.5,r'$\vec{F}_{3}, x_{3}$',fontsize='12')
ax.text(2.5,-8,r'$x$',fontsize='12')
ax.axis('off')
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_008.png")
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_008.svg")
'''








