#L_02_03.py
'''
Berechnung des Kreuzproduktes.
'''
import numpy as np
#Funktionsdefinition
def drehmoment(rx,ry,rz,Fx,Fy,Fz):
    r=np.array([rx,ry,rz])
    F=np.array([Fx,Fy,Fz])
    rb=np.sqrt(rx**2 + ry**2 + rz**2) #Hebellänge
    Fb=np.sqrt(Fx**2 + Fy**2 + Fz**2) #Betrag des Kraftvektors
    M=np.cross(r,F) #Kreuzprodukt
    Mb=np.sqrt(M[0]**2 + M[1]**2 + M[2]**2)
    alpha=np.arcsin(Mb/(rb*Fb))
    return M,rb,Fb,Mb,alpha
#Hebelarm in m
rx = 1   
ry = 2
rz = 3
#Kraftkomponenten in N
Fx = 200   
Fy = 100
Fz = 300
#Funktionsaufruf
M,r,F, Mb,alpha = drehmoment(rx,ry,rz,Fx,Fy,Fz)
#Ausgabe
print('Vektor des Drehmoments M =',M,'Nm')
print('Betrag des Drehmoments M = %2.2f Nm' %Mb)
print('Hebelarm r = %2.2F m' %r)
print('Betrag der Kraft F = %2.2F N' %F)
print('Winkel zwischen Kraftvektor und Hebelarm = %2.1f°' %np.degrees(alpha))



