#L_02_07.py
'''
#Simulation des Schwerpunkt eines Dreiecks
Für die Schwerpunktkoordinate S =(xs,ys) gilt:
xs=(x1+x2+x3)/3
ys=(y1+y2+y3)/3
'''
#Import der Module
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#y-Koordinaten festlegen
y1,y2,y3=10,20,0
#Slider abfragen
def update(val):
    x1 = sldX1.val
    x2 = sldX2.val
    x3 = sldX3.val
    y3 = sldY3.val
    sx,sy=(x1+x2+x3)/3,(y1+y2+y3)/3 #Schwerpunktkoordinate berechen
    r1.set_data([x1,x2],[y1,y2]) #Dreieckseiten zeichen
    r2.set_data([x2,x3],[y2,y3])
    r3.set_data([x3,x1],[y3,y1])
    s.set_data([sx],[sy]) #Schwerunkt zeichnen
    ax.set_title('S = (%1.1f, %1.1f)' %(sx,sy)) #Koordinatenwerte in der Titelleiste ausgeben
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,8),label="Schwerpunkt")
fig.subplots_adjust(left=0.005,bottom=0.28,right=0.99)
ax.axis([0,20,0,20])
s, =  ax.plot([],[],'ko',markersize=4) #Marker für Schwerpunkt
r1, = ax.plot([],[],'r')
r2, = ax.plot([],[],'r')
r3, = ax.plot([],[],'r')
#x-Slider positionieren
xyX1=fig.add_axes([0.09, 0.17, 0.82, 0.03])
xyX2=fig.add_axes([0.09, 0.12, 0.82, 0.03])
xyX3=fig.add_axes([0.09, 0.07, 0.82, 0.03])
xyY3=fig.add_axes([0.09, 0.02, 0.82, 0.03])
#x-Sliderobjekte erzeugen
sldX1=Slider(xyX1,'$x_{1}$',0,20,valinit=0,valstep=0.1)
sldX2=Slider(xyX2,'$x_{2}$',0,20,valinit=10,valstep=0.1)
sldX3=Slider(xyX3,'$x_{3}$',0,20,valinit=20,valstep=0.1)
sldY3=Slider(xyY3,'$y_{3}$',0,20,valinit=0,valstep=0.1)
#Slider updaten
sldX1.on_changed(update)
sldX2.on_changed(update)
sldX3.on_changed(update)
sldY3.on_changed(update)
ax.set_aspect('equal')
ax.set(xlabel='$x$',ylabel='$y$')
ax.grid()
plt.show()



