#sld_drehmoment.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
#Daten
r = 1    #Länge des Hebelarms in m
F=100    #Kraft in N
#Slider abfragen
def update(val):
    winkel = sldAlpha.val
    alpha=np.radians(winkel)
    x=r*np.cos(alpha-np.pi/2)
    y=r*np.sin(alpha-np.pi/2)
    Fx=F*np.sin(alpha)
    M=r*Fx
    txtM.set_text('$M$ = %.1f Nm' %M)
    txtAlpha.set_text('%.f°' %winkel)
    txtFx.set_text('$F_{x}$ = %.2f N' %Fx)
    txtFx.set(x = 0.05,y = y - 0.1)
    vFx.set_data([0,x],[y,y])
    vFy.set_data([0,0],[0,y])
    pfeilF.set_positions((0,0),(x,y))
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,8),label="Drehmoment")
fig.subplots_adjust(left=0.12,bottom=0.18)
ax.axis([-0.04,1.2*r,-1.2*r,1.2*r])
ax.plot(0,-r,'ko',markersize=8)  #Drehachse
ax.plot([0,0],[0,-r],'k-',lw=2)  #Hebelarm
vFx,= ax.plot([0,0.5],[-0.866,-0.866],'k--',lw=1.5)
vFy,= ax.plot([0,0],[0,-0.866],'k--',lw=1.5)
#Kraftvektor
SP = ArrowStyle.Simple(head_length=18,head_width=8)
pfeilF = FancyArrowPatch((0,0),(0.5,-0.866),color='red',arrowstyle=SP)
ax.add_patch(pfeilF)
#platzieren der Textelemente
txtM=ax.text(-0.05,-1.1*r,'$M$ = %.1f Nm' %50) #Drehmoment
txtAlpha=ax.text(-0.15,-0.01,'%.0f°'%30)       #Winkel
txtFx=ax.text(0.1,-1,'$F_{x}$ = %.2f  N' %50)
#Slider
xyAlpha=fig.add_axes([0.1, 0.02, 0.75, 0.03])
sldAlpha=Slider(xyAlpha,r'$\alpha$ in °',30,150,valinit=30,valstep=0.1)
sldAlpha.on_changed(update)
ax.set_axis_off() #ax.axis('off')
ax.set_aspect('equal')
ax.set_title('Länge des Hebelarms $r$ = %.2f m' %r)
plt.show()

#Listing 2.3






