#sld_massenschwerpunkt1.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import Circle,FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
rho=7.85 #Dichte von Stahl in kg/dm^2
l = 2    #Länge des Stabes in m
#Slider abfragen
def update(val):
    m1 = sldM1.val #Masse 1 in kg 
    m2 = sldM2.val #Masse 2 in kg 
    xs=m2/(m1+m2)*l
    r1=((3*rho*m1)/(4*np.pi))**(1/3)*0.025
    r2=((3*rho*m2)/(4*np.pi))**(1/3)*0.025
    txtM1.set_text('$m_{1}$ = %.1f kg' %m1)
    txtM2.set_text('$m_{2}$ = %.1f kg' %m2)
    txtXs.set_text('$x_{s}$ = %.2f m' %xs) #Schwerpunkt
    pfeilA.set_positions((xs,-0.1),(xs,0))
    kugel1.set_radius(r1)
    kugel2.set_radius(r2)
    return kugel1,kugel2
#Grafikbereich
fig, ax=plt.subplots(figsize=(10,4),label="Massenschwerpunkt")
fig.subplots_adjust(left=0.12,bottom=0.18)
ax.axis([-0.1,1.1*l,-1.1*l,1.1*l])
#Balken
ax.plot([0,l],[0,0],'k-',lw=2)
#Massen
kugel1 = Circle((0,0), radius=0.113,color='black')
kugel2 = Circle((l,0), radius=0.113,color='black')
ax.add_patch(kugel1)
ax.add_patch(kugel2)
#Drehachse
SP=ArrowStyle.Simple(head_length=20,head_width=20)
pfeilA = FancyArrowPatch((1,-0.1),(1,0),color='red',arrowstyle=SP)
ax.add_patch(pfeilA)
#platzieren der Textelemente
txtM1=ax.text(-0.1,0.3,'$m_{1}$ = %.1f kg' %50)
txtM2=ax.text(1.9,0.3,'$m_{2}$ = %.1f kg' %50)
txtXs=ax.text(-0.15,-0.3,'$x_{s}$ = %.2f m' %1)
#Slider
xyM1=fig.add_axes([0.09, 0.08, 0.82, 0.03])
xyM2=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldM1=Slider(xyM1,'$m_{1}$',10,100,valinit=50,valstep=0.01)
sldM2=Slider(xyM2,'$m_{2}$',10,100,valinit=50,valstep=0.01)
sldM1.on_changed(update)
sldM2.on_changed(update)
ax.set_axis_off()
ax.axis('equal')
ax.set_title('Abstand zwischen den beiden Kugeln $l$ = %1.1f m'%l)
plt.show()


#Listinval 2.7





