#!/usr/bin/env python3
#vp_kraeftegleichgewicht.py
from vpython import *
rho=2000   #Dichte von Beton in kg/m^3
g=9.81     #m/s^2
#Dehnung ändern
def seite(s):
    a=s.value
    V=a**3       #Volumen
    m=rho*V      #Masse
    Fg=m*g*1e-6  #Umwandlung in kN
    wuerfel.size=vec(a,a,a)
    pfeilFg.pos=vec(0,-a/2,0)
    pfeilFh.pos=vec(0, a/2,0)
    pfeilFg.axis.y = -Fg
    pfeilFh.axis.y =  Fg
    lblFh.text = '<i>F</i><sub>h</sub> =  %2.3e kN' %Fg #actio
    lblFg.text = '<i>F</i><sub>g</sub> = -%2.3e kN' %Fg #reactio
    txtSeite.text = '\t %2.1f' %s.value 
#Grafikbereich
scene.title="<h3>Kräftegleichgewicht: Kraft = Gegenkraft</h3>"
scene.width=400
scene.height=800
scene.center=vector(0,0,0)
scene.range=10
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False
#System im Gleichewicht
wuerfel=box(length=3, height=3,width=3)
wuerfel.pos=vec(0,0,0)
#Pfeil Hubkraft
pfeilFh=arrow(axis=vec(0, 5, 0),color=color.blue,round=True)
pfeilFh.pos=vec(0,0,0)
pfeilFh.shaftwidth=0.2
#Pfeil Gewichtskraft
pfeilFg=arrow(axis=vec(0, -5, 0),color=color.red,round=True)
pfeilFg.pos=vec(0,0,0)
pfeilFg.shaftwidth=0.2
#Label für Ausgabe der Federkräfte
lblFh=label(pos=vec(6, 18,0),text='Fh  = %2.1f kN' %4.3)
lblFg=label(pos=vec(6,-18,0),text='Fg  = %2.1f kN' %-4.3)
#****Slider für Kraftänderung****
scene.caption = "\nSeitenlänge ändern: \n\n" #Beschriftung des Sliders
#Sliderobjekt für Kraftänderung erzeugen
sldSeite = slider(bind=seite,min=3, max=8,value=6,length=400, right=15)
#Textfeld für Ausgabe der Seitenlänge
txtSeite = wtext(text='\t %2.1f' %sldSeite.value)
#Einheit der Seitenlänge
scene.append_to_caption(" m\n")
 