#!/usr/bin/env python3
#vp_slider_zylinder.py
from vpython import *
#Daten
l0=3
r0=3
x0 = -5
#Berechnungen durchführen
def schwerpunkt():
    l=sldLaenge.value
    xs=l/3
    y_achse.pos=vec(xs+x0,0,0)
    SP.pos=vec(xs+x0,0,0)
    kegel.length = l
    txtLaenge.text=text='\t %2.1f dm' %l
    lblXs.text = '<i>x</i><sub>s</sub> = %2.2f' %xs
#Eigenschaften der Zeichenfläche
scene.title="<h3>Schwerpunkt eines Kegels</h3>"
scene.background = color.white
scene.range=5
scene.userzoom = False    #kein Zoom
scene.userspin = False
#Zyliderobjekt erzeugen
kegel = cone(axis=vec(l0,0,0),radius=r0,color=color.red,opacity=0.4)
kegel.pos=vec(x0,0,0)
y_achse=arrow(axis=vec(0,5,0),round=True,color=color.black)
y_achse.pos=vec(x0,0,0)
x_achse=arrow(axis=vec(13,0,0),round=True,color=color.black)
x_achse.pos=vec(x0,0,0)
x_achse.shaftwidth=0.05
y_achse.shaftwidth=0.05
SP=sphere(pos=vec(x0,0,0),radius=0.15,color=color.black)
#Slider: Länge ändern
scene.caption = "\nLänge ändern: \n\n" #Beschriftung des Sliders
sldLaenge = slider(bind=schwerpunkt,min=1,max=12,step=0.1,value=l0,length=650)
txtLaenge = wtext(text='\t %2.1f dm' %sldLaenge.value)
#Ergebnisse ausgeben
lblXs = label(pos=vec(4,-4,0),text='<i>x</i><sub>s</sub> = %2.1f ' %1)

#achse=cylinder(pos=vec(x0,0,0),length=0.05,height=8,width=0.1,color=color.black)
