#abb_03_07.py
'''
Durchbiegung eines Balkens mit neutraler Faser
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Daten
F = 1e3 #N
b = 200 #Breite in mm
h = 300 #Höhe in mm
l = 5e3 #Länge des Balkens mm
E = 200 #kN/mm^2
q0=F/l
Iy=b*h**3/12 #Flächenmoment 2. Grades
#Funktionsdefinition für Biegelinie
def biegelinie(x):
    return -l**3*q0*x/(24*E*Iy) + l*q0*x**3/(12*E*Iy) - q0*x**4/(24*E*Iy)
#Grafikbereich
fig,ax=plt.subplots(figsize=(10,4))
ax.axis([-25,l+25,-50,50])
x=np.linspace(0,l,200)
ax.plot(x,biegelinie(x),'k-',lw=40,alpha=0.2)
ax.plot(x,biegelinie(x),'r-.',lw=1)
#Kraftvektoren
spitze = ArrowStyle.Simple(head_length=6,head_width=5)
pfeilF = FancyArrowPatch((l/2,15),(l/2,-9),color='red',arrowstyle=spitze) #Lastvektor
pfeilFa = FancyArrowPatch((0,-43),(0,-9.2),color='red',arrowstyle=spitze) #Auflagekraft Fa
pfeilFb = FancyArrowPatch((l,-43),(l,-9.2),color='red',arrowstyle=spitze) #Auflagekraft Fb
ax.add_patch(pfeilF)
ax.add_patch(pfeilFa)
ax.add_patch(pfeilFb)
#platzieren der Textelemente
ax.text(-25,-50,'$F_{A}$',fontsize=12)
ax.text(l-25,-50, '$F_{B}$',fontsize=12)
ax.text(l/2,16, '$F$',fontsize=12)
ax.set_axis_off()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF007.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF007.pdf")
plt.show()
