#abb_03_11.py
#Biegemoment für zweiseitig gelagerter Balken bei Einzellastlast
import numpy as np
import matplotlib.pyplot as plt
#
F=500  #N
l=4     #Länge des Balkens in m
#Einzellast
@np.vectorize
def biegemoment(x):
    if x < l/2:
        return -F*x/2
    elif x > l/2:
        return -F*(l-x)/2
#Grafikbereich
fig,ax=plt.subplots(figsize=(10,4))
x=np.linspace(0,l,1000)
ax.plot(x,biegemoment(x),'r-')
#Beschriftungen
ax.set_ylabel('$M_b$ in Nm')
ax.set_xlabel('$x$ in m')
ax.grid()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF0011.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF0011.pdf")
plt.show()
 

