#L_03_01.py
'''
Dehnung eines dünnen Drahtes
Berechnung des erforderlichen Drahtquerschnitts
'''
import numpy as np
import matplotlib.pyplot as plt
#Daten
sigma_zul=500 #zulässigige Zugspannung in N/mm^2
rho=7.85e-6   #Dichte des Drahtes in kg/mm^3
E=1.9e5       #N/mm^2
l=36          #Länge des Drahtes in m
m=30          #Masse der Kugel in kg
g=9.81        #Erdbeschleunigung in m/s^2
#erforderliche Querschnittsfläche in mm^2
A=m*g/(sigma_zul-rho*g*l) #mm^2
#Funktionsdefinition für Dehnung
def dehnung(z):
    return g*l*rho*z/E - g*rho*z**2/(2*E) + g*m*z/(A*E)
#Grafikbereich
fig,ax =plt.subplots()
z=np.linspace(0,l,200)
ax.plot(z,dehnung(z))
ax.set_xlabel('$z$')
ax.set_ylabel('$w(z)$')
ax.set_title('$A$ = %3.3f $\mathrm{mm^2}$' %A)
plt.show()