#L_03_05.py
'''
Darstellung der Durchbiegung bei Flächenlast
'''
import numpy as np
import matplotlib.pyplot as plt
#Daten
F = 1e4   #N
b = 0.05   #Breite in m
h = 0.1   #Höhe in m
l = 5     #Länge des Balkens m
E = 200e9 #N/m^2
#Berechnungen
q0=F/l
Iy=b*h**3/12 #Flächenmoment 2. Grades
Mbmax=F*l/4
sigma=Mbmax/Iy*h/2*1e-6 #Umwandlung in N/mm^2
#Funktionsdefinition für Biegelinie
def biegelinie(x):
    return -l**3*q0*x/(24*E*Iy) + l*q0*x**3/(12*E*Iy) - q0*x**4/(24*E*Iy)
#Grafikbereich
fig,ax=plt.subplots(figsize=(10,4))
ax.axis([0,l,-50,50])
x=np.linspace(0,l,200)
ax.plot(x,1e3*biegelinie(x),'k-',lw=20,alpha=0.2)
ax.plot(x,1e3*biegelinie(x),'r-.',lw=1)
#Beschriftungen
ax.set(xlabel='Länge in m',ylabel='Durchbiegung in mm')
ax.set_title('$\sigma_{b}$ = %2.1f $\mathrm{mm^2}$, $w$ = %2.1f mm' %(sigma,1e3*biegelinie(l/2)))
plt.show()
