#vp_zugversuch.py
from vpython import *
#Daten
E=2.1e5    #Elastizitätsmodul in N/mm^2 
A=10       #Querschnittsfläche der Probe in mm^2
l0 = 1000  #Stablänge in mm
#Dehnung ändern
def dehnung(s):
    dl=s.value #aktuelle Stablänge
    probe.axis.x = dl + 5
    pfeilFz.pos=probe.pos + vec(dl + 5,0,0)
    pfeilFz.axis.x = dl + 5
    epsilon=dl/l0       #Dehnung
    F=E*A*epsilon*1e-3  #Federkraft in kN
    lblFz.text = '<i>F</i><sub>z</sub> =  %2.2f kN' %F #Zugkraft
    txtWeg.text = '\t %2.2f' %s.value 
#Grafikbereich
scene.title="<h3>Zugversuch</h3>"
scene.width=800
scene.height=400
scene.center=vector(0,0,0)
scene.range=10
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False
#Wand für Befestigung der Probe
wand=box(pos=vec(-10, 0, 0),length=2, height=15, width=2,color=color.black)
#Stab als Probe
probe=cylinder(axis=vector(5,0,0),radius=1.4)
probe.pos=wand.pos
#Pfeil für Zugkraft
pfeilFz=arrow(axis=vec(10, 0, 0),color=color.red,round=True)
pfeilFz.shaftwidth=0.4
pfeilFz.pos=probe.pos
#Label für Ausgabe der Federkräfte
lblFz=label(pos=vec(+15,-9,0),text='<i>F</i><sub>z</sub>  = %2.2f kN' %0)
#****Slider für Wegänderung****
scene.caption = "\nDehnung ändern: \n\n" #Beschriftung des Sliders
#Sliderobjekt für Dehnung erzeugen
sldWeg = slider(bind=dehnung,min=0,max=10,value=0,length=700,right=15)
#Textfeld für Ausgabe der Dehnung
txtWeg = wtext(text='\t %2.2f' %sldWeg.value)
#Einheit des Wegs
scene.append_to_caption(" mm\n")

    