#ani_kreisbewegung.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from matplotlib.patches import FancyArrowPatch,ArrowStyle
r=1         #Radius der Umlaufbahn in m
T=1         #Periodendauer in s
dt=2e-3     #Zeitschrittweite
w=2*np.pi/T #Kreisfrequenz
xmax,ymax=1.5*r,1.5*r
#x,y-Werte für Kreis
def kreis(t,r,w,phase=0):
    x=r*np.cos(w*t+phase)
    y=r*np.sin(w*t+phase)
    return x,y
#Kreisbahn berechnen
def kreisbahn(i):
    t=i*dt
    v=w*r    #Bahngeschwindigkeit
    vx,vy=-r*w*np.sin(w*t),r*w*np.cos(w*t) #Geschwindigkeitskomponenten berechnen
    txtVx.set_text('$v_{x}$ = %.2f m/s' %vx)
    txtVy.set_text('$v_{y}$ = %.2f m/s' %vy)
    x,y=kreis(t,r,w) #s(t)
    r2=1.2
    phase=np.arccos(r/r2)
    x2,y2=kreis(t,r2,w,phase) #Kreiskoordinaten
    pfeilV.set_positions((x,y),(x2,y2))       #v(t)      
    pfeilA.set_positions((x,y),(0.3*x,0.3*y)) #a(t)
    masse.set_data([x],[y])
    return masse,txtVx,txtVy,pfeilV,pfeilA
#Grafikbereich
fig,ax=plt.subplots(figsize=(5,5))
ax.axis([-xmax,xmax,-ymax,ymax])
t=np.arange(0,T,dt)
x,y = kreis(t,r,w)
ax.plot(x,y,'k-') #Kreis zeichnen
ax.plot(0,0,'ko') #Drehachse
masse, = ax.plot([],[],'ko',markersize=8) #schwarzer Punkt
txtVx = ax.text(-1.4,1.3,'')
txtVy = ax.text(-1.4,1.1,'')
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilV = FancyArrowPatch((0,0),(0,0),color='blue',arrowstyle=spitze)
pfeilA = FancyArrowPatch((0,0),(0,0),color='red',arrowstyle=spitze)
ax.add_patch(pfeilV)
ax.add_patch(pfeilA)
ani=FuncAnimation(fig,kreisbahn,frames=t.size,interval=20,blit=True)
ax.set_aspect('equal')
ax.set_xticks([])
ax.set_yticks([])
plt.show()

#Listing 4.9


