#ani_wurf.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from matplotlib.patches import FancyArrowPatch,ArrowStyle
v0=20          #Anfangsgeschwindigkeit in m/s
wurfwinkel=45  #Abwurfwinkel in °
alpha=np.radians(wurfwinkel)
g=9.81   #m/s^2
dt=5e-3  #Zeitschrittweite
delta_x = 4
xmax,ymax=42,12
#x,y = f(t)
def s(t,v0,alpha):
    x=v0*np.cos(alpha)*t
    y=v0*np.sin(alpha)*t-0.5*g*t**2
    return x,y
#Geschwindigkeit
def v(t):
    vx=v0*np.cos(alpha)
    vy=v0*np.sin(alpha)-g*t
    return vx,vy,np.hypot(vx,vy)
#Wurfbahn berechnen
def wurfbahn(i):
    t=i*dt
    x,y=s(t,v0,alpha)
    vx,vy,vs=v(t)
    delta_y=vy/vx*delta_x
    x2,y2=x+delta_x, y+delta_y
    pfeilV.set_positions((x,y),(x2,y2))
    ball.set_data([x],[y])
    txtZeit.set_text('$t$ = %.2f s' %t)
    txtGeschwindigkeit.set_text('$v$ = %.2f m/s' %vs)
    return ball,txtZeit,txtGeschwindigkeit,pfeilV
#Grafikbereich
fig,ax=plt.subplots(figsize=(8,4))
ax.axis([0,xmax,0,ymax])
tmax=2*v0*np.sin(alpha)/g
t=np.arange(0,tmax,dt)
x,y=s(t,v0,alpha)
ax.plot(x,y) #statische Bahnkurve zeichnen
ax.set(xlabel="$x$ in m",ylabel="$y$ in m")
ball, = ax.plot([],[],'yo',markersize=10)
#Textelemente
txtZeit=ax.text(0.5,11.1,'')
txtGeschwindigkeit=ax.text(0.5,10.4,'')
#Pfeil
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilV = FancyArrowPatch((0,0),
                         (0,0),
                         color='red',arrowstyle=spitze)
ax.add_patch(pfeilV)
#Animation
ani=FuncAnimation(fig,wurfbahn,frames=t.size,interval=20,blit=True)
plt.show()

