#L_04_02.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
v0=5   #m/s
s=0.5  #Knautschzone in m
#Berechnungen
tb=s/v0 #Bremszeit
a0=v0/tb 
#Geschwindigkeit
def v(t):
    return -a0*t+v0
#1.Ableitung
def diff(t,f,h=1e-1):
    return ((f(t+h))-f(t-h))/(2*h)
#Beschleunigung
def a(t):
    return diff(t,v)
#Grafikbereich
fig,ax=plt.subplots(2,1)
t=np.linspace(0,tb,500)
ax[0].plot(t,v(t))
ax[1].plot(t,a(t))
fig.tight_layout()
#Beschriftungen
ax[0].set(ylabel='v in m/s',title='Geschwindigkeit')
ax[1].set(xlabel='t in s',ylabel='a',title='Beschleunigung')
fig.tight_layout()
plt.show()


'''
from numdifftools import Derivative
def a1(t):
    df=Derivative(v,n=1)
    return df(t)
'''