#L_04_04a.py
#Weg-Zeit-Gesetz: zentraler Differenzenquotient
import numpy as np
import matplotlib.pyplot as plt
g=9.81 #Erdbeschleunigung in m/s^2
#1.Ableitung
def diff(t,f,h=1e-9):
    return ((f(t+h))-f(t-h))/(2*h)
#Weg
def s(t):
    return g*t**2/2
#Geschwindigkeit
def v(t):
    return diff(t,s)
#Beschleunigung
def a(t):
    return diff(t,v,1e-3)
#Grafikbereich
fig,ax=plt.subplots(3,1)
t=np.linspace(0,10,200)
ax[0].plot(t,s(t)) #Weg
ax[1].plot(t,v(t)) #Geschwindigkeit
ax[2].plot(t,a(t)) #Beschleunigung
#
plt.show()
