#L_04_06.py
#Wurfparabel y=f(x)
import numpy as np
import matplotlib.pyplot as plt
y0=1.8   #Abwurfhöhe
alpha=45 #Abwurfwinkel
v0=28    #Afangsgeschwindigkeit
g=9.81   #Erdbeschleunigung
alpha=np.radians(alpha)
xw=v0**2*np.sin(2*alpha)/g      #Wurfweite
hw=v0**2*np.sin(alpha)**2/(2*g) #Wurfhöhe
#y=f(x)
def y(x,v0,alpha):
    return -g/(2*v0**2*np.cos(alpha)**2)*x**2 + np.tan(alpha)*x + y0
#Grafikbereich
fig,ax=plt.subplots(figsize=(12,6),label='Schiefer Wurf')
x=np.linspace(0,xw,500)
ax.set_ylim([0,hw+y0+5])
ax.plot(x,y(x,v0,alpha))
ax.text(0,hw+5,r'$y(x)=-\frac{g}{2v_{0}^{2}\cos^{2} \alpha} x^{2}+\tan \alpha \cdot x+y_{0}$',fontsize=14)
ax.set(xlabel='x in m',ylabel='y in m',title='Schiefer Wurf')
plt.show()
        