#sld_geschwindigkeit_weg.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
tmax=10 #s
vmax=30 #m/s
v0=vmax/2
#Geschwindigkeit
def vc(v):
    return 0*t + v
#Weg
def s(v):
    return v*t
#Slider abfragen
def update(val):
    v = sldV.val
    geschwindigkeit.set_data(t,vc(v))
    weg.set_data(t,s(v))
#Grafikbereich
fig = plt.figure(figsize=(8,5))
#zwei Unterdiagramme erzeugen
left,bottom,width,height=0.12,0.08,0.8,0.30
ax1 = fig.add_axes([left,bottom+0.5,width,height])#Geschwindigkeit
ax2 = fig.add_axes([left,bottom+0.06,width,height])#Weg
t=np.linspace(0,tmax)
#Wertebereich der x und y-Achsen
ax1.axis([0,tmax,0,1.2*vmax])
ax2.axis([0,tmax,0,300])
#Initialisierung der Funktionen
geschwindigkeit, = ax1.plot(t,vc(v0),'r-')
weg, = ax2.plot(t,s(v0),'b-')
#Slider Position: left,bottom,width,height
xyV=fig.add_axes([0.08, 0.02, 0.82, 0.02])
sldV=Slider(xyV,'$v$',0,vmax,valinit=v0,valstep=0.1)
sldV.on_changed(update)
#Beschriftungen
ax1.set(ylabel=r'$v$  in  $\mathrm{\frac{m}{s}}$',title='Geschwindigkeit')
ax2.set(xlabel='$t$ in s',ylabel='$s$ in m',title='Weg')
plt.show()




