#sld_kreisbewegung.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
from matplotlib.patches import FancyArrowPatch,ArrowStyle
r0=1.0
xmax=ymax=1.10 
#x,y-Werte für Kreis
def kreis(phi,r):
    x=r*np.cos(phi)
    y=r*np.sin(phi)
    return x,y
#Slider abfragen
def update(val):
    r = sldR.val #Radius
    T = sldT.val #Periodendauer
    w=2*np.pi/T  #Winkelgeschwindigkeit
    v=w*r        #Bahngeschwindigkeit
    a=w**2*r     #Radialbeschleunigung
    txtW.set_text(r'$\omega$ = %.2f 1/s' %w)
    txtV.set_text('$v$ = %.2f m/s' %v)
    txtA.set_text(r'$a_{r} = %.2f \ \frac{m}{s^{2}} $ ' %a)
    x,y=kreis(phi,r)
    pfeilA.set_positions((0,r),(0,0))
    pfeilV.set_positions((0,r),(-r,r))
    kurve.set_data([x],[y])
    punkt.set_data([0],[r])
#Grafikbereich
fig, ax=plt.subplots(figsize=(5,5))
ax.axis([-xmax,xmax,-xmax,ymax])
phi=np.linspace(0,2*np.pi,500)
x,y=kreis(phi,r0)
kurve, = ax.plot(x,y,'k-')
punkt, = ax.plot(0,r0,'ro')
fig.subplots_adjust(left=0.1,bottom=0.24)
#Ausgaben
txtW = ax.text(-0.95,1.2, r'$\omega$ = %.2f 1/s' %3.14)
txtV = ax.text(-0.2,1.2, '$v$ = %.2f m/s'  %3.14)
txtA = ax.text(0.6,1.2, r'$a_{r}$ = %.2f $\mathrm{\frac{m}{s^{2}}}$' %9.87)
ax.text(0.05,0.5,'$a_{r}$')
ax.text(-0.9,0.85,'$v$')
#Vektoren
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilA = FancyArrowPatch((0,r0),(0,0),color='red',arrowstyle=spitze)
pfeilV = FancyArrowPatch((0,r0),(-r0,r0),color='blue',arrowstyle=spitze)
ax.add_patch(pfeilA)
ax.add_patch(pfeilV)
#Slider
xyR=fig.add_axes([0.08, 0.08, 0.82, 0.03])
sldR=Slider(xyR,r'$r$',0.2,1,valinit=r0,valstep=0.01)
xyT=fig.add_axes([0.08, 0.02, 0.82, 0.03])
sldT=Slider(xyT,r'$T$',1,10,valinit=2,valstep=0.1)
sldR.on_changed(update)
sldT.on_changed(update)
ax.set_aspect('equal')
ax.set_axis_off()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF015.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF015.pdf")
plt.show()

#Listing 4.8

