#sld_weg_zeit_gesetz.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
tmax=10 #s
amax=10 #m/s^2
a0=amax/2
#konstante Beschleunigung
def ac(a):
    return 0*t+a
#Geschwindigkeit
def v(a):
    return a*t
#Weg
def s(a):
    return 0.5*a*t**2
#Slider abfragen
def update(val):
    a = sldA.val
    beschleunigung.set_data(t,ac(a))
    geschwindigkeit.set_data(t,v(a))
    weg.set_data(t,s(a))
#Grafikbereich
fig = plt.figure(figsize=(8,9),label='Weg-Zeit-Gesetz')
#drei Unterdiagramme erzeugen
left,bottom,width,height=0.12,0.08,0.8,0.23
ax1 = fig.add_axes([left,bottom+0.6,width,height])#Beschleunigung
ax2 = fig.add_axes([left,bottom+0.3,width,height])#Geschwindigkeit
ax3 = fig.add_axes([left,bottom,width,height])    #Weg
t=np.linspace(0,tmax)
#Wertebereich der x und y-Achsen
ax1.axis([0,tmax,-12,12])
ax2.axis([0,tmax,-100,100])
ax3.axis([0,tmax,-500,500])
#Initialisierung der Funktionen
beschleunigung, = ax1.plot(t,ac(a0),'g-')
geschwindigkeit, = ax2.plot(t,v(a0),'r-')
weg, = ax3.plot(t,s(a0),'b-')
#Slider Position: left,bottom,width,height
xyA=fig.add_axes([0.08, 0.01, 0.82, 0.02])
sldA=Slider(xyA,'$a$',-amax,amax,valinit=a0,valstep=0.1)
sldA.on_changed(update)
#Beschriftungen
ax1.set(ylabel='$s$ in m',title='Beschleunigung')
ax1.set(ylabel=r'$a$  in  $\mathrm{\frac{m}{s^{2}}}$')
ax2.set(ylabel=r'$v$  in  $\mathrm{\frac{m}{s}}$',title='Geschwindigkeit')
ax2.text(0.3,80,r'$v=a\cdot t$',fontsize=12)
ax3.set(xlabel='$t$ in s',ylabel='$s$ in m',title='Weg')
ax3.text(0.3,380,r'$s=\frac{1}{2} a\cdot t^{2}$',fontsize=12)
plt.show()



