#sld_wurf2.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
g=9.81
xmax,ymax=80,40 
#Wurfzeit
def wurfzeit(v0,alpha):
    return 2*v0*np.sin(alpha)/g
#x,y-Werte
def f(t,v0,alpha):
    x=v0*np.cos(alpha)*t
    y=v0*np.sin(alpha)*t-g*t**2/2
    return x,y
#Slider abfragen
def update(val):
    winkel = sldAlpha.val
    v0 = sldV0.val
    alpha=np.radians(winkel)
    tw = wurfzeit(v0,alpha)
    t=np.linspace(0,tw,100)
    x,y=f(t,v0,alpha)
    kurve.set_data(x,y)
#Grafikbereich
fig, ax=plt.subplots(label='Simulation des Abwurfwinkels')
fig.subplots_adjust(left=0.1,bottom=0.24)
ax.axis([0,xmax,0,ymax])
kurve, = ax.plot([],[],'b-')
xyV0=fig.add_axes([0.08, 0.08, 0.82, 0.03])
xyAlpha=fig.add_axes([0.08, 0.02, 0.82, 0.03])
sldV0=Slider(xyV0,r'$v_{0}$',10,25,valinit=25,valstep=0.1)
sldAlpha=Slider(xyAlpha,r'$\alpha $',10,80,valinit=45,valstep=0.1)
sldV0.on_changed(update)
sldAlpha.on_changed(update)
ax.set(xlabel='$x$ in m',ylabel='$y$ in m')
plt.show()

# tw = wurfzeit(25,np.pi/4)
# t=np.linspace(0,tw,100)
# x,y=f(t,25,np.pi/4)
# kurve, = ax.plot(x,y,'b-')
