#textbox_schiefer_wurf.py
import math
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import TextBox
g=9.81 #Erdbeschleunigung m/s^2
#s=f(t)
def wurf(winkel):
    v0=20
    alpha=float(winkel)
    alpha=np.radians(alpha) #Abwurfwinkel
    tw=2*v0*np.sin(alpha)/g #Wurfzeit
    t=np.linspace(0,tw)
    x=v0*np.cos(alpha)*t
    y=v0*np.sin(alpha)*t-g*t**2/2
    wurfbahn.set_data(x,y)
    plt.draw()
#Grafikbereich
fig, ax = plt.subplots()
ax.axis([0,42,0,20])
fig.subplots_adjust(bottom=0.2)
wurfbahn, = ax.plot([], [], lw=1)
#left, bottom, width, height
xyBox = fig.add_axes([0.46, 0.02, 0.1, 0.075])
txtA = TextBox(xyBox,r'$\alpha $',textalignment="center")
txtA.on_submit(wurf)
txtA.set_val('45') #Defaultwert für Abwurfwinkel
ax.set(xlabel='$x$ in m',ylabel='$y$ in m')
plt.show()

#Listing 4.4
'''
ax.relim()
ax.autoscale_view()
txtA.on_text_change(weg)
'''

