#!/usr/bin/env python3
#vp_schiefer_wurf.py
from vpython import *
#Daten
v0=23   #Anfangsgeschwindigkeit
dt=1e-2 #Zeitschrittweite
g=9.81
laenge= 60   #Laenge der Bezugsebene
dicke = 2
R = 2  #Radius für Ball
y0 = R + dicke/2
#boolesche Variable
run = False
#
def startStop(e):
    global run
    run = not run
    if run:
        e.text = "Stop"
    else:
        e.text= "Start"
#
def winkel(e):
    txtA.text = "%2.0f" %e.value
#Grafikbereich
scene.title="<h3>Schiefer Wurf</h3>"
scene.background=color.white
scene.width= 640 #Standardwert: 640 Pixel
scene.height=500 #Standardwert: 400 Pixel
scene.userzoom = False    #kein Zoom
scene.center=vector(0,laenge/4,0) #Position des Beobachters
#Ball
ball = sphere(radius=R,color=color.yellow)
ball.pos=vec(-laenge/2,y0,0)
#Ebene
ebene=box(size=vec(laenge,dicke,laenge/2),color=color.green)
ebene.pos=vec(0,0,0)
#Slider für Abwurfwinkel
scene.append_to_caption("\n\n")
scene.caption="\n  Abwurfwinkel ändern:\n\n"
sldWinkel=slider(bind=winkel,min=20,max=80,value=45,length=700)
txtA=wtext(text="%2.1f" %sldWinkel.value)
scene.append_to_caption(" °\n\n")
#Start-Stop-Button
cmdS=button(bind=startStop,pos=scene.caption_anchor)
cmdS.text="Start"
#Textausgaben
lblX=label()
lblY=label()
lblZeit=label()
lblGeschwindigkeit=label()
lblZeit.pos = ebene.pos + vec(-30,-10,0)
lblX.pos = ebene.pos + vec(-10,-10,0)
lblY.pos = ebene.pos + vec(10,-10,0)
lblGeschwindigkeit.pos = ebene.pos + vec(30,-10,0)
#Animationsschleife
t=x=v=y=0
tw=0
while True:
    rate(30)
    if not run:
        alpha=radians(sldWinkel.value)
    if run:
        x = v0*cos(alpha)*t
        y = y0 + v0*sin(alpha)*t - 0.5*g*t**2 
        vx = v0*cos(alpha)
        vy = v0*sin(alpha) - g*t
        v = sqrt(vx**2+vy**2)
        ball.pos = vec(x - laenge/2,y,0)
        tw=t       #Wurfzeit
        t+=dt
        if y < y0: #Ball erreicht den Boden
            t=v=y=0
            run=False
            if run == False:
                cmdS.text="Start"
    #Ausgaben
    lblZeit.text = '<em>t</em> = %.1f s' %tw
    lblX.text = '<em>x</em> = %2.1f m' %x
    lblY.text = '<em>y</em> = %2.1f m' %y
    lblGeschwindigkeit.text = '<em>v</em> = %2.1f m/s' %v
 
'''
#maximale Wurfweite
def wurfweite(v0,alpha):
    return v0**2*sin(2*alpha)/g
print(wurfweite(v0,alpha))
'''