#03_003.py
#Rechteck auf Ebene, actio=reactio
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Figure und Axes Objekte erzeugen
fig, ax = plt.subplots(figsize=(6,3))
#x1,x2,y1,y2
ax.axis([-41,41,-30,30])
#x1,y1,x2,y2
masse1 = mpl.patches.Circle((-20,0),20,fill=True,lw=1,color='blue',alpha=0.2)
masse2 = mpl.patches.Circle((30,0),8,fill=True,lw=1,color='red',alpha=0.2)
#x,y-Position, Text
ax.text(7,2,r"$\overrightarrow{F}$",color='r',fontsize='12')
ax.text(-22,-2,r"$m_{1}$",fontsize='12')
ax.text( 28,-2,r"$m_{2}$",fontsize='12')
ax.text(15,2,r"$\overrightarrow{F}$",color='r',fontsize='12')
#Position A, Position B
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilF1= FancyArrowPatch((0,0),(10,0),color='blue',arrowstyle=spitze)
pfeilF2= FancyArrowPatch((22,0),(13,0),color='blue',arrowstyle=spitze)
#Objekte darstellen
ax.add_patch(masse1)
ax.add_patch(masse2)
ax.add_patch(pfeilF1)
ax.add_patch(pfeilF2)
ax.axis('off')
ax.set_aspect('equal')
fig.tight_layout()
plt.show()
