#abb_05_013.py
#Kräfteplan für fallende Kugel
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Grafikbereich
fig, ax = plt.subplots(figsize=(8,6))
ax.axis([-5,5,-5,5])
ax.plot(0,0,'ko',markersize=50,alpha=1.0) #Ball
#Pfeilspitze
spitze = ArrowStyle.Simple(head_length=12,head_width=8)
d=0.1
#Luftwiderstand
pfeilFw = FancyArrowPatch((-d,0),
                         (-d,3),
                         color='red',arrowstyle=spitze,lw=1.5,zorder=0)
#Trägheitskraft
pfeilFa = FancyArrowPatch((d,0),
                         (d,4),
                         color='red',arrowstyle=spitze,lw=1.5)
#Erdanziehungskraft
pfeilFg = FancyArrowPatch((0,0),
                         (0,-3),
                         color='blue',arrowstyle=spitze,lw=1.5)
#
ax.add_patch(pfeilFw)
ax.add_patch(pfeilFa)
ax.add_patch(pfeilFg)
#
ax.text(-0.64,1.8,'$F_{w}$',fontsize=12)
ax.text( 0.34,1.8,'$F_{a}$',fontsize=12)
ax.text(-1.1,-0.1,'$m$',fontsize=12)
ax.text( 0.23,-1.8,'$F_{g}$',fontsize=12)
#
ax.set_xticks([])
ax.set_yticks([])
ax.set_frame_on(False)
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_05-NF013.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_05-NF013.pdf")
plt.show()