#abb_05_012.py
#Luftwiderstand für Fussball
import numpy as np
import matplotlib.pyplot as plt
#Daten
m=0.45    #Masse der Kugel in kg
d=0.22    #Durchmesser der Kugel in Meter
rho=1.225 #Luftdichte in kg/m^3
cw=0.2    #Strömungswiderstandskoeffizient
g=9.81    #Erdbeschleunigung in m/s^2
tmax=10   #Zeitintervall
#Berechnungen
A=np.pi*(d/2)**2 #Querschitt der Kugel
v=np.linspace(0,30,100)
Fw=0.5*rho*cw*A*v**2 #Luftwiderstand
#Grafikbereich
fig, ax = plt.subplots(figsize=(8,6))
ax.plot(v,Fw,'b-',label='Luftwiderstand')
ax.grid(True)
ax.set(xlabel='$v$ in m/s',ylabel='$F_{w}$ in N')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_05-NF012.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_05-NF012.pdf")
plt.show()

'''
Daten für Fußball
Umfang 68 bis 70 cm
Durchmesser: 22 cm
Masse 410 bis 450 g
cw-Wert für Kugel: 0.1 bis 0.4 Kuchling, Tabelle 7, S.622
'''