#L_05_04.py
#Anfahren mit Beschleunigung a = 5*cos(0,1*t) 
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import quad
#Daten
v0=0    #m/s
a01= 5  #m/s^2
c=0.1   #1/s
ta = 5  #Anfahrzeit in Sekunden
m=100   #kg
#beschleunigen
#@np.vectorize
def beschleunigung(t):
    return a01*np.cos(c*t)
#Kraft
def kraft(t):
    return m*beschleunigung(t)
#Geschwindigkeit
@np.vectorize
def geschwindigkeit(t):
    return quad(beschleunigung,0,t)[0] + v0
#Weg
@np.vectorize
def weg(t):
    return quad(geschwindigkeit,0,t)[0]
#Grafikbereich
fig, ax = plt.subplots(2,2,figsize=(8,8),label='Anfahrvorgang')
t=np.linspace(0,ta,200)
ax[0,0].plot(t,beschleunigung(t),'g-') #Beschleunigung
ax[0,1].plot(t,kraft(t),'k-')               #Kraft
ax[1,0].plot(t,geschwindigkeit(t),'b') #Geschwindigkeit
ax[1,1].plot(t,weg(t),'r-') #weg
#Beschriftungen
ax[0,0].set(ylabel=r'$a$ in m/$\rm s^{2}$',title='Beschleunigung')
ax[0,1].set(ylabel='$F$ in N',title='Kraft')
ax[1,0].set(xlabel='$t$ in s',ylabel='$v$ in m/s',title='Geschwindigkeit')
ax[1,1].set(xlabel='$t$ in s',ylabel='$s$ in m',title='Weg')
fig.tight_layout()
plt.show()

#print(geschwindigkeit(ta))




