#L_05_07.py
'''
Fußball-Bahnkurve
Lösung mit dem Euler-Verfahren
'''
import numpy as np
import matplotlib.pyplot as plt
#Daten
v0=30     #m/s
alpha=45  #Abwurfwinkel°
m=0.45    #Masse der Kugel in kg
d=0.22   #Durchmesser der Kugel in Meter
cw=0.2    #Strömungswiderstandskoeffizient
rho=1.225 #Luftdichte in kg/m^3
g=9.81    #Erdbeschleunigung in m/s^2
dt=0.01   #Zeitschrittweite
#Berechnungen
alpha=np.radians(alpha)
xmax=v0**2*np.sin(2*alpha)/g
ymax=v0**2*np.sin(alpha)**2/(2*g)
tmax=2*v0*np.sin(alpha)/g  #Wurfzeit
A=np.pi*(d/2)**2 #Querschitt der Kugel
b=1/2*rho*cw*A   #Reibungskonstante
#Wurf mit Luftwiderstand
def wurf(tmax,v0,alpha,b):
    #Anfangswerte
    vx=v0*np.cos(alpha)
    vy=v0*np.sin(alpha)
    t=x=y=0         
    lt,lx,ly=[],[],[]  #drei leere Listen
    #Lösung der DGL mit dem Euler-Verfahren
    while t<=tmax:
        v=np.sqrt(vx**2 + vy**2)
        vx = vx - b*vx*v/m*dt      
        vy = vy - g*dt - b*vy*v/m*dt
        x =  x + vx*dt 
        y =  y + vy*dt   
        lx.append(x)
        ly.append(y)
        t+=dt
    return lx,ly
#Grafikbereich
fig,ax =plt.subplots(figsize=(8,4))
ax.set_xlim(0,1.05*xmax)
ax.set_ylim(0,1.05*ymax)
#ideal b = 0
x1,y1=wurf(tmax,v0,alpha,0)
ax.plot(x1,y1,'b-',label='ideal')
#real b != 0
x2,y2=wurf(tmax,v0,alpha,b)
ax.plot(x2,y2,'r-',label='real')
#Beschriftungen
ax.set(xlabel='$x$ in m',ylabel='$y$ in m')
ax.legend(loc='best')
fig.tight_layout()
plt.show()