#sld_beschleunigungsmesser.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
from matplotlib.patches import FancyArrowPatch,ArrowStyle
m=100   #Masse, die beschleunigt werden soll in kg
g=9.81  #Erdbeschleunigung in m/s^2
#Slider abfragen
def update(val):
    winkel = sldPhi.val #Auslenkwinkel
    phi=np.radians(winkel)
    a=g*np.tan(phi) #Beschleunigung
    F=m*a
    x=-10*np.sin(phi)
    y=-10*np.cos(phi)
    pfeilP.set_positions((0,0),(x,y)) #Pendelposition
    kugel.set_data([x],[y])
    pfeilA.set_positions((0,0),(a,0)) #Pfeil für Beschleunigung
    pfeilF.set_positions((0,-10),(a,0))
    txtPhi.set_text(r'$\varphi = %.f {}^{\circ}$' %winkel)
    txtA.set_text(r'$a$ = %.1f in m/$\rm s^{2}$' %a) #Beschleunigung
    txtF.set_text('$F$ = %.f N' %F) #Kraft
#Grafikbereich
fig, ax = plt.subplots(1,2,figsize=(8,6),label='Beschleunigungsmesser')
fig.subplots_adjust(left=0.12,bottom=0.2)
ax[0].axis([-6,6,-12,2])
ax[1].axis([-2,8,-12,2])
#Diagramm links
#Pendelfaden
pfeilP = FancyArrowPatch((0,0),
                         (-2.5,-9.7),
                         color='blue')
#Kugel für Pendel
kugel, = ax[0].plot([-2.5,-2.5],[-9.7,-9.7],'ko',markersize=12)
#Diagramm rechts
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
#Beschleunigungsvektor in x-Richtung
pfeilA = FancyArrowPatch((0,0),
                         (2.5,0),
                         color='red',arrowstyle=spitze)
#Erdbeschleunigung
pfeilG = FancyArrowPatch((0,0),
                         (0,-10),
                         color='red',arrowstyle=spitze)
#Faden
pfeilF = FancyArrowPatch((0,-10),
                         (2.5,0),
                         color='red',arrowstyle=spitze)

ax[0].add_patch(pfeilP)
ax[1].add_patch(pfeilA)
ax[1].add_patch(pfeilG)
ax[1].add_patch(pfeilF)
#Textausgaben
txtPhi=ax[0].text(-0.55,1,r'$\varphi = %.f {}^{\circ}$' %15)      #Winkel
txtF=ax[1].text(3.8,1.1,'$F$ = 263 N') #Kraft
txtA=ax[1].text(-1.6,1.1,r'$a$ = %.1f in m/$\rm s^{2}$' %2.6)
ax[1].text(-1.85,-4.8,r'$g\cdot m$') #Beschriftung Fg
#x-, y-Position, Laenge, Hoehe
xyPhi = fig.add_axes([0.1, 0.05, 0.8, 0.03]) #Auslenkwinkel
sldPhi=Slider(xyPhi,r'$\varphi$',0.0,30.0,valinit=15,valstep=0.1)
sldPhi.on_changed(update)
ax[0].set_xticks([]);ax[0].set_yticks([])
ax[1].set_xticks([]);ax[1].set_yticks([])
plt.show()



