#sld_bremsen.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
m=100     #kg
vmax=15   #m/s
tmax=5    #Sekunden
tr=1      #Reaktionszeit in Sekunden
v0=10     #m/s
#Beschleunigung beim Abbremsen
def beschleunigung(tb):
    return -v0/tb
#Geschwindigkeitsverlauf während des Bremsens
def bremsgeschwindigkeit(t,tb):
    a=beschleunigung(tb)
    return a*t+v0
#Slider abfragen
def update(val):
    tb = sldTb.val   #Bremszeit
    a=beschleunigung(tb)
    s=v0*tb/2        #Bremsweg: Dreiecksfläche
    F=m*a                          #Bremskraft
    txtS.set_text('$s$ = %.2f m' %s) #Bremsweg
    txtA.set_text(r'$a$ = %.1f in m/$\rm s^{2}$' %a) #Beschleunigung
    txtF.set_text('$F$ = %.1f N' %F) #Bremskraft
    geschwindigkeit.set_data([t],[bremsgeschwindigkeit(t,tb)])
#Grafikbereich
fig, ax=plt.subplots()
ax.axis([0,tmax,0,vmax])
txtA=ax.text(0.5,14,r'$a$ = %.1f m/$\rm s^{2}$' %-2) #Beschleunigung
txtF=ax.text(1.9,14,'$F$ = %.1f N' %-200)   #Kraft
txtS=ax.text(3.4,14,'$s$ = %.2f m' %25)      #Bremsweg
t=np.linspace(0,tmax,500)  #1 Dimensionales Array für Bremszeit
geschwindigkeit, = ax.plot(t,bremsgeschwindigkeit(t,tmax),'r-')
fig.subplots_adjust(left=0.12,bottom=0.18)
xyTb=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldTb=Slider(xyTb,'$t$ in s',tr,tmax,valinit=tmax,valstep=0.01)
sldTb.on_changed(update)
#Beschriftungen
ax.set_title('Bremsvorgang')
ax.set_xlabel('$t$  in s')
ax.set_ylabel('$v$  in m/s')
plt.show()




