#!/usr/bin/env python3
#vp_actio.py
from vpython import *
#Daten
m=100       #Masse in kg
dt = 1e-2   #Zeitschrittweite
breite=20   #Breite der Bodenplatte
dicke=0.2   #Dicke der Bodenplatte
tiefe=5     #Tiefe der Bodenplatte
kasten=2  #Breite des Wuerfels
#boolesche Varablen
run = False
#Animation anhalten    
def startStop(e):
    global run
    run = not run
    if run: e.text = "Stop"
    else: e.text = "Start"
#Wert der Kraft anzeigen
def kraft(s):
    txtKraft.text = '\t %2.0f' %s.value 
#Grafikbereich
scene.title="<h3>Zweites Newtonsche Axiom: beschleunigte Bewegung</h3>"
scene.width =800 #Standardwert: 640 Pixel
scene.height=400 #Standardwert: 400 Pixel
scene.center=vector(0,10*dicke,0)
scene.background = color.white
scene.userzoom = False    #kein Zoom
#scene.userspin = False
scene.range=0.35*breite
#Unterlage und Würfel, x0,y0,z0,Laenge, Hoehe, Tiefe
unterlage=box(size=vec(breite,dicke,tiefe),opacity=0.5)
unterlage.pos=vector(0,0,0) #Position der Unterlage
#zu bewegender Koerper
koerper=box(size=vector(kasten,kasten,kasten),color=color.red) #Masse
koerper.pos = vector(-breite/2+kasten/2,kasten/2+dicke/2,0) #Anfangsposition
#-------------------------------------------------------------
#****Slider für Wegänderung****
scene.caption = "\nAntriebskraft &auml;ndern: \n\n" #Beschriftung Slider
#Sliderobjekt für Kraft erzeugen
sldKraft = slider(bind=kraft,min=1,max=100, value=50,length=550,right=15)
#Textfeld für Ausgabe der Kraft
txtKraft = wtext(text='\t %2.0f' %sldKraft.value)
#Einheit der Kraft
scene.append_to_caption(" N\n\n")
#------------------------------------------------------------
#***Button für Start, Stop***
button(bind=startStop,text="Start",pos=scene.caption_anchor)
#------------------------------------------------------------
#***Label für Ausgaben****
lblWeg = label()
lblZeit = label()
lblGeschwindigkeit = label()
lblWeg.pos = unterlage.pos + vector(-5,-4,0)
lblZeit.pos = unterlage.pos + vector(0,-4,0)
lblGeschwindigkeit.pos = unterlage.pos + vector(5,-4,0)
#****************************
t=x=v=0
#***Animation***
while True:
    rate(1/dt)
    if run:
        F = sldKraft.value #Antriebskraft
        a = F/m            #Beschleunigung
        v = a*t            #Geschwindigkeit
        x = a*t**2/2       #Weg
        koerper.pos = vec(x - breite/2+kasten/2,dicke/2 + kasten/2,0)
        t+=dt
    if x >= (breite - kasten):
        t=0
    #Textausgabe
    lblWeg.text = '<em>x</em> = %.1f m' %x
    lblZeit.text = '<em>t</em> = %.1f s' %t
    lblGeschwindigkeit.text = '<em>v</em> = %.1f m/s' %v

#Es werden ideale Bedingungen vorausgesetzt: keine Reibungsverluste