#!/usr/bin/env python3
#vp_actio_reactio.py
from vpython import *
kf=10   #Federkonstante N/cm
x0=5    #Startwert für Dehnung
#Funktionsdefiniion für Dehnung
def weg(s):
    pfeilFa.pos=feder.pos + vector(s.value,0,0)
    pfeilFa.axis.x = s.value  #nach rechts
    pfeilFr.axis.x = -s.value #nach links
    feder.axis.x = s.value
    F=kf*s.value  #Federkraft
    lblFa.text = '<i>F</i><sub>a</sub> =  %2.1f N' %F #actio
    lblFr.text = '<i>F</i><sub>r</sub> = -%2.1f N' %F #reactio
    txtWeg.text = '\t %2.2f' %s.value
#Graphikbereich
scene.title="<h3>Drittes Newtonsche Axiom: actio = reactio</h3>"
scene.width=800
scene.height=400
scene.center=vector(0,0,0)
scene.range=10
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False
#Feder
feder=helix(axis=vector(x0,0,0),radius=1.4)
feder.thickness=0.2
feder.coils=10
feder.pos=vector(-x0,0,0)
#Pfeil actio, zeigt nach rechts
pfeilFa=arrow(color=color.red,round=True)
pfeilFa.axis=vec(x0, 0, 0)
pfeilFa.shaftwidth=0.4
pfeilFa.pos=feder.pos + vec(x0,0,0)
#Pfeil reactio, zeigt nach links
pfeilFr=arrow(color=color.red,round=True)
pfeilFr.axis=vec(-x0, 0, 0)
pfeilFr.shaftwidth=0.4
pfeilFr.pos=feder.pos
#Label für Ausgabe der Federkräfte
lblFa=label(pos=vec(+17,-9,0),text='<i>F</i><sub>a</sub> =  %2.1f N' %50)
lblFr=label(pos=vec(-17,-9,0),text='<i>F</i><sub>r</sub> = -%2.1f N' %50)
#****Slider für Wegänderung****
scene.caption = "\nDehnung ändern: \n\n" 
#Sliderobjekt für Dehnung erzeugen
sldWeg=slider(bind=weg, min=1, max=10,value=x0,length=700)
#Textfeld für Ausgabe der Dehnung
txtWeg=wtext(text='\t %2.2f' %sldWeg.value)
#Einheit des Wegs
scene.append_to_caption(" cm\n")
