#!/usr/bin/env python3
#vp_realer_wurf.py
from vpython import *
#Daten
v0=42     #Anfangsgeschwindigkeit
m=0.45    #Masse der Kugel in kg
d=0.22    #Durchmesser der Kugel in Meter
cw=0.2    #Stroemungswiderstandskoeffizient
rho=1.225 #Luftdichte in kg/m^3
alpha0=45
dt=1e-2   #Zeitschrittweite
g = 9.81
laenge= 100  #Laenge der Bezugsebene
dicke = 1    #Bodenplatte
R = 1  #Radius fuer Ball (nur fuer Darstellung)
y0 = R + dicke/2
#Berechnungen
A=pi*(d/2)**2    #Querschitt der Kugel
b=1/2*rho*cw*A   #Reibungskonstante
#boolesche Variable
run = False
#starten oder stoppen
def startStop(e):
    global run
    run = not run
    if run:
        e.text = "Stop"
    else:
        e.text= "Start"
#fuer Ausgabe des Abwurfwinkels
def winkel(e):
    txtA.text = "%2.0f" %e.value
#Grafikbereich
scene.title="<h3>Schiefer Wurf mit Luftwiderstand </h3>"
scene.background=color.white
scene.width= 800 #Standardwert: 640 Pixel
scene.height=500 #Standardwert: 400 Pixel
scene.userzoom = False    #kein Zoom
scene.center=vector(0,laenge/5,0) #Position des Beobachters
scene.range=0.5*laenge
#Ball
ball = sphere(radius=R,color=color.yellow)
ball.pos=vec(-laenge/2,y0,0)
#Ebene
ebene=box(size=vec(laenge,dicke,laenge/2),color=color.green)
ebene.pos=vec(0,0,0)
#Slider fuer Abwurfwinkel
scene.append_to_caption("\n\n")
scene.caption="\n  Abwurfwinkel &auml;ndern:\n\n"
sldWinkel=slider(bind=winkel,min=20,max=80,value=alpha0,length=780)
txtA=wtext(text="%2.1f" %sldWinkel.value)
scene.append_to_caption(" °\n\n") #Winkel in Grad
#Start-Stop-Button
cmdS=button(bind=startStop,pos=scene.caption_anchor)
cmdS.text="Start"
#Textausgaben
lblX=label()
lblY=label()
lblZeit=label()
lblGeschwindigkeit=label()
yu=-20 #Abstand der Ausgaben
lblZeit.pos = ebene.pos + vec(-30,yu,0)
lblX.pos = ebene.pos + vec(-10,yu,0)
lblY.pos = ebene.pos + vec(10,yu,0)
lblGeschwindigkeit.pos = ebene.pos + vec(30,yu,0)
#Animationsschleife
y=h=y0
t=x=tw=xw=v=0
alpha=radians(alpha0)
vx=v0*cos(alpha) #Anfangswert fuer vx
vy=v0*sin(alpha) #Anfangswert fuer vy
while True:
    rate(30)
    if not run:
        t=x=vx=vy=0
        y=y0
        alpha=radians(sldWinkel.value)
        vx=v0*cos(alpha)
        vy=v0*sin(alpha)
    if run:
        v=sqrt(vx**2 + vy**2)
        vx = vx - b*vx*v*dt/m
        vy = vy - g*dt - b*vy*v*dt/m
        x = x + vx*dt
        y = y + vy*dt
        ball.pos = vec(x - laenge/2,y,0)
        h=y        #Wurfhoehe
        xw=x       #Wurfweite
        tw=t       #Wurfzeit
        t+=dt
        if y < y0: #Ball erreicht den Boden
            t=x=vx=vy=0
            y=y0
            run=False
            if run == False:
                cmdS.text="Start"
    #Ausgaben
    lblZeit.text = '<em>t</em> = %.1f s' %tw
    lblX.text = '<em>x</em> = %2.1f m' %xw
    lblY.text = '<em>y</em> = %2.1f m' %abs(h-y0)
    lblGeschwindigkeit.text = '<em>v</em> = %2.1f m/s' %v
 


