#!/usr/bin/env python3
#vp_traegheitsaxiom.py
from vpython import *
#Daten
breite=5.  #Breite der Zeichenfläche
R=8.       #Radius der Umlaufbahn
r=1        #Radius der Kugel
w=1        #Winkelgeschwindigkeit
dt=1e-2    #Zeitschrittweite
#boolesche Variable
run = True
# Animation anhalten    
def startStop(b):
    global run
    run = not run
    if run: b.text = "Stop"
    else: b.text = "Start"
#Grafikbereich
scene.title="<h3>Erstes Newtonsche Axiom: Trägheitsprinzip</h3>"
scene.width=600
scene.height=600
scene.range=2.5*breite
scene.background = color.white
scene.userzoom = False 
#Bahn
orbit=ring(pos=vec(0,0,0),axis=vec(0,0,1),thickness=0.05)
orbit.radius=R + r
masse = sphere(radius=r,color=color.red)
# Start-Stop-Button
button(bind=startStop,text="Stop",pos=scene.caption_anchor )
#Animationsschleife
t=0
while True:
    rate(100)
    if run:
        x=R*sin(w*t)
        y=R*cos(w*t)
        masse.pos = vector(x,y,0)
        t+=dt
        
'''
Hinweis
Man denke an die Plantenbewegung.
'''



