#abb_06_002.py
#Veranschaulichung des Skalarprodukts
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#
xmax,ymax=18,18
#Grafikbereich
fig, ax=plt.subplots()
plt.rc('font', size=12)
ax.axis([0,xmax,0,ymax])
x1,y1=2,5
x2,y2=15,5
Fx,Fy=10,15
#Pfeile
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
#Zugkraft
F = FancyArrowPatch((x1,y1),
                         (Fx,Fy),
                         color='red',arrowstyle=spitze,lw=2)

Fx = FancyArrowPatch((x1,y1),
                         (10,y1),
                         color='red',arrowstyle=spitze,lw=2)


Fy = FancyArrowPatch((10,5),
                         (10,15),
                         color='red',arrowstyle=spitze,lw=2)


s = FancyArrowPatch((x1,y1-0.5),
                         (x2+2,y2-0.5),
                         color='black',arrowstyle=spitze)


ax.add_patch(F)
ax.add_patch(Fx)
ax.add_patch(Fy)
ax.add_patch(s)
ax.grid(False)
#Beschriftungen
ax.text(6.4,3.3,'$s$')
ax.text(5.6,11.1,'$F$')
ax.text(10.4,8.5,'$F_{y}$')
ax.text(6.1,5.7,'$F_{x}$')
ax.text(4.1,6.1,r'$\alpha$')
ax.set_axis_off()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF001.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF001.pdf")
plt.show()

