import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import Arc
from matplotlib.animation import FuncAnimation

r=1

sk=1.2

fig,ax= plt.subplots(figsize=(8, 8))
plt.rc('font', size=12)
ax.axis([-sk*r,sk*r,-0.2,sk*r])
schale=Arc((0,r),2.*r,2.*r,angle=0.0,theta1=180,theta2=360,lw=1,color='k',ls='-.')
ax.add_patch(schale)
#x1,x2, y1 ,y2
ax.plot([0,0],[0,r],'k-') #waagerechte Linie
ax.plot([0,0.85],[0.5,0.5],'k-') #senkrechte Linie
ax.plot([0,0.85],[0,0.5],'k-') #Hypotenuse
ax.plot([0,0.85],[1,0.5],'k-') #Radius
ax.plot([0.85,0.85],[0.5,0.5],'ro') #Punkt

#
ax.text(-0.18,0.7,'$r$ - $h$')
ax.text(-0.14,0.26,'$h$')
ax.text(0.4,0.8,'$r$')
ax.text(0.08,0.8,r'$\varphi$')
ax.set_aspect('equal')
ax.set_axis_off()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF013.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF013.pdf")
plt.show()