#sld_kraefte_addieren.py
#Simulation des Skalarprodukts
#berechnet wird die mechanische Arbeit
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
Fmax = 100  #N
smax = 10   #m
sxy=0.1   #Skalierungsfaktor
#Slider abfragen
def update(val):
    x = sldX.val
    y = sldY.val
    Fx = sldFx.val#*0.1
    Fy = sldFy.val#*0.1
    s=np.array([x,y])
    F=np.array([Fx,Fy])
    W=np.dot(F,s)
    alpha=np.arccos(W/(np.hypot(F[0],F[1])*np.hypot(s[0],s[1])))
    txtW.set_text('$W$ = %2.1f Nm' %W)
    txtAlpha.set_text(r'$\alpha$ = %2.1f °' %np.degrees(alpha))
    pfeilS.set_positions((0, 0),(x,y))
    pfeilF.set_positions((0, 0),(Fx*sxy,Fy*sxy))
#Grafikbereich
fig, ax=plt.subplots(label="Skalarprodukt")
fig.subplots_adjust(left=0.12,bottom=0.3)
ax.axis([-1,1.1*smax,-1,1.1*smax])
ax.plot(0,0,'ko',markersize=8)
txtW = ax.text(0,1.2*smax,'') #für Ausgabe der Arbeit
txtAlpha = ax.text(0.5*smax,1.2*smax,'') #für Ausgabe der Arbeit
#Pfeile
spitze = ArrowStyle.Simple(head_length=10,head_width=6,tail_width=0.8)
pfeilS=FancyArrowPatch((0,0),(10,10),color='blue',arrowstyle=spitze)#Weg
pfeilF=FancyArrowPatch((0,0),(5,5),color='red',arrowstyle=spitze)  #Kraft
ax.add_patch(pfeilS)
ax.add_patch(pfeilF)
#Slider
xyX=fig.add_axes([0.09, 0.17, 0.82, 0.03])
xyY=fig.add_axes([0.09, 0.12, 0.82, 0.03])
xyFx=fig.add_axes([0.09, 0.07, 0.82, 0.03])
xyFy=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldX=Slider(xyX,'$x$',0,smax,valinit=5,valstep=0.1)
sldY=Slider(xyY,'$y$',0,smax,valinit=5,valstep=0.1)
sldFx=Slider(xyFx,'$F_{x}$',0,Fmax,valinit=50,valstep=0.1)
sldFy=Slider(xyFy,'$F_{y}$',0,Fmax,valinit=50,valstep=0.1)
sldX.on_changed(update)
sldY.on_changed(update)
sldFx.on_changed(update)
sldFy.on_changed(update)
#ax.set_aspect('equal')
ax.set(xlabel='$x$',ylabel='$y$')
ax.grid()
plt.show()



# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_02-NF002.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_02-NF002.pdf")

