#plot_beschleunigung.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
m=1400  #Masse in kg
vmax=30 #maximale Geschwindigkeit in m/s
#Funktionsdefinition
def beschleunigungsarbeit(v,m):
    return 1/2*m*v**2*1e-3
#Grafikgereich
fig, ax = plt.subplots()
v=np.linspace(0,vmax,200)
ax.plot(v,beschleunigungsarbeit(v,m),'r-')
ax.grid(True)
#Beschriftungen
ax.set_xlabel('$v$ in m/s')
ax.set_ylabel('$W$ in kJ')
plt.show()

