#plot_wirkungsgrad.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
U=400      #Spannung in V
eta=0.8    #Wirkungsgrad
m=1400     #Masse in kg
A=2        #Querschnittsfläche des Fahrzeugs in m^2
cw=0.28    #Strömungswiderstandsbeiwert
my=0.015   #Rollwiderstandsbeiwert
g=9.81     #m/s^2
rho=1.225  #Luftdichtekg/m^3
#Funktionsdefinition
def stromstaerke(v):
    return (1/2*rho*A*cw*v**3 + my*m*g*v)/(eta*U)
#Grafikgereich
fig, ax = plt.subplots()
v=np.linspace(0,30,200)
ax.plot(v,stromstaerke(v),'r-')
ax.grid(True)
#Beschriftungen
ax.set_xlabel('$v$ in m/s')
ax.set_ylabel('$I$ in A')
plt.show()

