#sld_reibarbeit.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Daten
Fn=1000   #Normalkraft
my=0.2    #Reibungskoeffizient
h = 2     #Höhe der Kiste
xmax,ymax = 6,10 #Zeichenbereich
pfeilL = 1.0
#Slider abfragen
def update(val):
    s = sldWeg.val   #Weg in m
    my = sldMy.val   #Gleitreibungszahl
    alpha=sldWinkel.val
    alpha=np.radians(alpha)
    F=my*Fn/np.cos(alpha)
    W=my*Fn*s      #Arbeit in J
    txtFn.set_text('$F_{n}$ = %.1f N' %Fn)
    txtF.set_text('$F$ = %.1f N' %F)   
    txtW.set_text('$W$ = %.1f J' %W)
    y=xmax*pfeilL*np.tan(alpha)
    pfeilF.set_positions((s,1.7),(s + pfeilL,1.7 + y)) #Zugkraft
    masse.set_data([s,s],[0,h]) #Bewegung
#Grafikbereich
fig, ax = plt.subplots(figsize=(8,4))
fig.subplots_adjust(left=0.12,bottom=0.35)
ax.axis([-0.5,xmax,0,1.1*ymax])
#Ausgaben
txtFn=ax.text(-0.25,9,'$F_{n}$ = %.1f N' %Fn) #Normalkraft
txtF=ax.text(1.5,  9,'$F$ = %.1f N' %(Fn*my)) #Zugkraft
txtW=ax.text(3.5, 9,'$W$ = %.1f J' %0)        #Arbeit
#Kiste
masse, = ax.plot([0,0],[0,2],'r-',lw=50,alpha=0.8)
#Pfeil
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
#Zugkraft
pfeilF = FancyArrowPatch((0,1.7),
                         (1,1.7),
                         color='black',arrowstyle=spitze)
ax.add_patch(pfeilF)
#Slider: links, unten, breite, hoehe
xyWeg   =fig.add_axes([0.12, 0.15, 0.8, 0.03]) #Weg
xyWinkel=fig.add_axes([0.12, 0.08, 0.8, 0.03]) #Winkel
xyMy    =fig.add_axes([0.12, 0.01, 0.8, 0.03]) #Reibung
sldWeg=Slider(xyWeg,'$s$ in m',0,5,valinit=0,valstep=0.1) #Weg
sldWinkel=Slider(xyWinkel,r'$\alpha$ in °',0,45,valinit=0,valstep=0.1) #Winkel
sldMy=Slider(xyMy,r'$\mu$',0.2,0.8,valinit=0.02,valstep=0.01)#Reibung
sldWeg.on_changed(update)
sldWinkel.on_changed(update)
sldMy.on_changed(update)
#Beschriftungen
ax.set_yticks([])
ax.set_xlabel('$s$ in m')
plt.show()



