#!/usr/bin/env python3
#vp_hubarbeit.py
from vpython import *
m=100  #Masse in kg
g=9.81 #Erdbeschleunigung
#Höhe ändern
def hoehe(s):
    h=sldHoehe.value #Höhe ermitteln
    masse.pos.y = h  #Masse anheben
    F=m*g            #Kraft berechnen
    W=F*h            #Arbeit berechnen
    lblF.text = '<i>F</i> = %2.1f N' %F  #Kraft
    lblW.text = '<i>W</i> = %2.1f Nm' %W #Arbeit
    txtHoehe.text = '\t %2.2f' %s.value
#Grafikbereich
scene.title="<h3>Hubarbeit</h3>"
scene.width=400
scene.height=800
scene.range=10
scene.center=vector(0,10,0)
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False
#Boden, Bezugsebene
platte=box(length=20, height=1, width=2)
platte.pos=vec(0,-2,0)
#Masse
masse=sphere(radius=1.1,color=color.red)
masse.pos=vec(0,0,0)
#Label für Ausgabe der Kraft und Hubarbeit
lblF=label(pos=vec(-6,-5,0),text='F  = %2.2f °' %0)
lblW=label(pos=vec( 5,-5,0),text='W  = %2.2f °' %0)
#****Slider für Höhenänderung****
scene.caption = "\nHöhe ändern: \n\n" #Beschriftung des Sliders
#Sliderobjekt für Höhe erzeugen
sldHoehe = slider(bind=hoehe,min=0,max=20,value=0,length=400,right=15)
#Textfeld für Ausgabe der Dehnung
txtHoehe = wtext(text='\t %2.2f' %sldHoehe.value)
#Einheit des Wegs
scene.append_to_caption(" m\n")
  