#!/usr/bin/env python3
#vp_kinetische_energie.py
from vpython import *
#Daten
m = 10  #Masse in kg
h = 20  #Fallhöhe
r = 1.2 #Radius der Kugel
g=9.81  #Erdbeschleunigung
# Animation anhalten    
def startStop(b):
    global run
    run = not run
    if run: b.text = "Stop"
    else: b.text = "Start"
#Grafikbereich
scene.title="<h3>Kinetische Energie</h3>"
scene.width=400
scene.height=800
scene.range=10
scene.center=vector(0,10,0)
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False
#Boden, Bezugsebene
platte=box(length=20, height=1, width=2)
platte.pos=vec(0,-1.5*r,0)
#Masse
kugel=sphere(radius=r,color=color.red)
kugel.pos=vec(0,0,0)
#Label für Ausgabe der Kraft und Hubarbeit
lblY = label(pos=vec(-6,-4,0),text='')
lblV = label(pos=vec(-6,-6,0),text='')
lblEpot=label(pos=vec(5,-4,0),text='')
lblEkin=label(pos=vec(5,-6,0),text='')
# boolesche Varablen
run = True
# Start-Stop-Button
button(bind=startStop,text="Stop",pos=scene.caption_anchor )
dt=1e-6 #Zeitschrittweite
t=0
tmax= sqrt(2*h/g) #Fallzeit für Zeile 56
#Animationsschleife
while True:
    rate(1e3/dt)
    if run:
        y = h - g*t**2/2
        v = g*t
        t+=dt
        kugel.pos.y = y 
        #Energie
        Epot=m*g*y            #potentielle Energie berechnen
        Ekin = m*v**2/2       #kinetische Energie berechnen
        #Ausgaben
        lblY.text = '<i>y</i>(t) = %2.1f m' %y         #aktuelle Fallhöhe
        lblV.text = '<i>v</i>(t) = %2.1f m/s' %v       #aktuelle Geschwindigkeit
        lblEpot.text = '<i>E</i><sub>pot</sub> = %2.1f Nm' %Epot  #potentielle Energie
        lblEkin.text = '<i>E</i><sub>kin</sub> = %2.1f Nm' %Ekin  #kinetische Energie
        if t >= tmax:  #alternativ y <= 0
            t=0

#Animation durch Mausklick anhalten
# run = True
# def running(ev):
#     global run
#     run = not run
# scene.bind('mousedown', running) 
