#!/usr/bin/env python3
#vp_kugelpendel.py
from vpython import *
m=10      #kg
g=9.81    #Erdbeschleunigung
breite=5. #Breite der Zeichenfläche
l=8.      #Länge des Pendels = Radius der Kreisschale
phi=80.   #Auslenkung
r=1       #Radius der Kugel
run = True
# Animation anhalten    
def startStop(b):
    global run
    run = not run
    if run: b.text = "Stop"
    else: b.text = "Start"
#Grafikbereich
scene.title="<h3>Kugelpendel</h3>"
scene.width=600
scene.height=600
scene.range=2.5*breite
scene.background = color.white
scene.userzoom = False 
orbit=ring(pos=vec(0,0,0),axis=vec(0,0,1),thickness=0.05)
orbit.radius = l + r
masse = sphere(radius=r,color=color.red)
# Start-Stop-Button
button(bind=startStop,text="Stop",pos=scene.caption_anchor )
#Label-Objekte
lblEpot=label(pos=vec(-8,-11,0),text='')
lblEkin=label(pos=vec(0,-11,0),text='')
lblEges=label(pos=vec(8,-11,0),text='')
#Quadrat der Kreisfrequenz
w02=g/l  
phi=radians(phi) 
w=0.      #Anfangswinkelgeschwindigkeit
dt=1e-2   #Zeitschrittweite
while True:
    rate(100)
    if run:
        phi=phi+w*dt
        w=w-w02*sin(phi)*dt #-0.001*w
        x= l*sin(phi)
        y=-l*cos(phi)
        v=w*l
        h=l+y
        Epot=m*g*h       #potentielle Energie
        Ekin=0.5*m*v**2  #kinetische Energie
        Eges=Epot + Ekin
        masse.pos = vector(x,y,0)
        lblEpot.text = '<i>E</i><sub>pot</sub> = %2.0f Nm' %Epot  
        lblEkin.text = '<i>E</i><sub>kin</sub> = %2.0f Nm' %Ekin  
        lblEges.text = '<i>E</i><sub>ges</sub> = %2.0f Nm' %Eges  


