#abb_07_001.py
#Kraftstoß, mittlere Kraft
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import quad
Fmax=10
t1,t2=0,6
#Dichtefunktion
def kraftstoss(x,sigma,my):
    y=Fmax*np.exp(-0.5*(x-my)**2/sigma**2)#/(sigma*np.sqrt(2*np.pi))
    return y

s=1
m=3
t = np.arange(0, m + 3*s, 0.01);
y = kraftstoss(t,s,m)
Fm=quad(kraftstoss,t1,t2,args=(s,m))[0]
Fx=Fm/(t2-t1)
#
fig, ax=plt.subplots()
ax.spines[["top", "right"]].set_visible(False)
ax.plot(1, 0, ">k", transform=ax.get_yaxis_transform(), clip_on=False)
ax.plot(-0.1, 1, "^k", transform=ax.get_xaxis_transform(), clip_on=False)
ax.set_xlim(-0.1,7)
ax.set_ylim(0,11)
ax.plot(t, y,'b-')
ax.fill_between(t,y,alpha=0.2)
ax.plot([0,6], [Fx,Fx],"r-")
ax.plot( [0,0],[0,Fx],"k--")
ax.plot( [6,6],[0,Fx],"k--")
#
#ax.text(2.9,5.0,"$S$")
ax.set_xlabel('Stoßzeit $t_s$')
ax.set_ylabel(r'Kontaktktaft  $F\left( t \right)$')
ax.set_xticks([])
ax.set_yticks([])
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_07-NF001.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_07-NF001.pdf")
plt.show()

