#!/usr/bin/env python3
#vp_gerader_stoss.py
from vpython import *
#Daten
v1= 4   #Geschwindigkeit v1
v2= 0   #Geschwindigkeit v2
x1=-1   #Anfangsposition für Kugel1: -1,0,1: links, Mitte, rechts
x2= 0   #Anfangsposition für Kugel2: -1,0,1: links, Mitte, rechts
R=0.4   #Radius der Kugeln
b = 5   #Breite = 2*b
h=b/2   #Höhe
RAND = b - R
f=0.75  #Faktor für Eindringtiefe
dt=0.01 #Zeitschrittweite
#Boolesche Variable
run = False
#Entscheidung für Stop oder Start
def startStop(b):
    global run
    run = not run
    if run:
        b.text = "Stop"
    else:
        b.text = "Start"
#Graphikbereich
scene.title="<h3>Gerader elastischer Stoß</h3>"
scene.height=800
scene.width= 800
scene.background = color.white
scene.range=1.2*b
#Kugel1
kugel1=sphere(radius=R,color=color.red)
kugel1.pos=RAND*vec(x1,0,0) #Position links
kugel1.v=v1*vec(1,0,0)      #Geschwidigkeitsvektor
#Kugel2
kugel2=sphere(radius=R,color=color.blue)
kugel2.pos=RAND*vec(x2,0,0) #Position rechts
kugel2.v=v2*vec(1,0,0)      #Geschwidigkeitsvektor
#Rahmen zeichnen
rahmen=[vec(-b,h,0),vec(b,h,0),vec(b,-h,0),vec(-b,-h,0),vec(-b,h,0)]
curve(pos=rahmen,color=color.black)
#Befehlsschaltfläche
button(bind=startStop,text="Start",pos=scene.caption_anchor)
# Animation
while True:
    rate(100)
    if run:
        #Kollisionsprüfung
        abstand=mag(kugel1.pos - kugel2.pos) #Abstand zwischen den Kugeln
        if abstand<(f*kugel1.radius + f*kugel2.radius):
            d=norm(kugel2.pos - kugel1.pos) #Normierung des Differenzvektors
            u1=dot(kugel1.v,d) #Abstand zwischen v1 und d
            u2=dot(kugel2.v,d) #Abstand zwischen v2 und d
            richtung=u2-u1 #das Vorzeichen bestimmt die Bewegungsrichtung
            #wenn richtung positiv nach rechts bewegen
            #wenn richtung negativ nach links bewegen 
            kugel1.v=kugel1.v + richtung*d
            #wenn richtung negativ nach rechts bewegen
            #wenn richtung positiv nach links bewegen 
            kugel2.v=kugel2.v - richtung*d 
        # Kugeln bewegen
        kugel1.pos = kugel1.pos + kugel1.v*dt #Kugel1 bewegen
        kugel2.pos = kugel2.pos + kugel2.v*dt #Kugel2 bewegen
        # Aufprall auf Rand
        if not(-RAND <= kugel1.pos.x <= RAND):
            kugel1.v.x = -kugel1.v.x #Richtungsumkehr
        if not(-RAND <= kugel2.pos.x <= RAND):
            kugel2.v.x = -kugel2.v.x #Richtungsumkehr
        


'''
u1 = ((m1-m2)*v1 + 2*m2*v2)/(m1+m2)
u2 = ((m2-m1)*v2 + 2*m1*v1)/(m1+m2)
'''
