#!/usr/bin/env python3
#vp_drehimpuls.py
from vpython import *
scene.width = 500
scene.height = 400
scene.range = 1.3
scene.background = color.white
scene.userzoom = False        
scene.userspin = False
#scene.title = "Drehimkpuls\n"
r0=1 #maximaler Abstand der Kugeln zur Drehachse
m=1  #Masse einer Kugel in kg
w0=0.5 #Anfangswert der Winkelgeschwindigkeit 1/s
#Boolsche Variable
running = False
#Entscheidung für Stop oder Start
def startStop(b):
    global running
    running = not running
    if running:
        b.text = "Stop"
    else:
        b.text = "Start"
#zwei Kugeln
kugel1 = sphere(pos=vec(r0,0,0),radius=0.1,color=color.red)
kugel2 = sphere(pos=vec(-r0,0,0),radius=0.1,color=color.blue)
#Beschriftung
scene.caption = "\n  Abstand ändern: \n\n"
#Radius ermitteln
def radius(s):
    txtR.text = '{:1.2f}'.format(s.value)
#Slider für Winkelgeschwindigkeit
sldR = slider(min=0.3, max=r0, value=r0, length=420, bind=radius, right=15)
#Textfeld für Ausgabe der Winkelgeschwindigkeit
txtR = wtext(text='{:1.2f}'.format(sldR.value))
#Einheit des Radius in Meter
scene.append_to_caption(' m\n\n')
#Label für Ausgabe der Winkelgeschwindigkeit 
lblW2=label(pos=vec(-1.25,-1.2,0),text='<em>\u03C9</em>  = %.1f 1/s' %0)
lblErot=label(pos=vec(1.25,-1.2,0),text='<em>E</em><sub>rot</sub>  = %.1f J' %0)
#Befehlsschaltfläche
button(text="Start",pos=scene.caption_anchor,bind=startStop)
#Animationsschleife
phi=radians(360) #
dt = 0.01
while True:
    rate(100)
    r=sldR.value
    if running:
        w2=r0**2/r**2*w0
        Erot=m*r**2*w2**2
        phi=phi + w2*dt
        x=r*cos(phi)
        y=r*sin(phi)
        kugel1.pos=vec(x,y,0)
        kugel2.pos=vec(-x,-y,0)
        lblW2.text= '<em>\u03C9</em> = %.2f 1/s' %w2
        lblErot.text= '<em>E</em><sub>rot</sub> = %.2f J' %Erot


#         L0=m*r0**2*w0
#         L2=m*r**2*w2
#         print(L0," ",L2)
'''
Literatur
Orear: S. 197
'''
