#!/usr/bin/env python3
#vp_hammerwurf.py
from vpython import *
#Daten
m=7.26     #Masse der Kugel in kg
r=2.135/2. #Radius in m
J=m*r**2   #Trägheitsmoment
dt=5e-3 #Zeitschrittweite
#boolesche Variable
laeuft = False
#Funktionsdefinition für Start und Stop
def startStop(e):
    global laeuft
    laeuft = not laeuft
    if laeuft: e.text = "Stop"
    else: e.text = "Start"
#Periodendauer anzeigen
def frequenz(s):
    txtF.text = "%1.2f" %s.value
#Grafikbereich
scene.title="<h3>Hammerwurf</h3>"
scene.width=scene.height=500 #Standardwerte: 640x400 Pixel
scene.background=color.white
scene.userspin=False #Drehung der Scene wird unterdrueckt
scene.center=vector(0,0,0)
scene.autoscale=False
scene.range = 1.2*r
#Hammer=Kugel+Seil
kugel=sphere(pos=vec(-r,0,0),radius=r/20,color=color.red)
seil=cylinder(pos=vec(0,0,0),axis=vector(-r,0,0),radius=r/200)
#Slider: Drehfrequenz einstellen
scene.append_to_caption("\n\n")
scene.caption="\n  Drehfrequenz &auml;ndern:\n\n"
sldF=slider(bind=frequenz,min=0,max=4,value=0,length=500,right=4)
txtF=wtext(text="%2.1f" %sldF.value) #Ausgabe Drehfrequenz
scene.append_to_caption(" 1/s\n\n")
#Befehlsschaltfläche
button(text="Start",pos=scene.caption_anchor,bind=startStop)
#Label für Ausgabe
lblJ=label(pos=vec(-0.9,1.1,0),text='<em>J</em>  = %.2f kgm<sup>2</sup>' %J) #Traegheitsmoment
lblW=label(pos=vec(-1,-1.12*r,0),text='<em>\u03C9</em>  = 0 1/s')            #Winkelgeschwindigkeit
lblV=label(pos=vec(-0.4,-1.12*r,0),text='<em>v</em>  = 0 m/s')          #Geschwindigkeit
lblDrehimpuls=label(pos=vec(0.19,-1.12*r,0),text='<em>L</em>  = 0 Nms') #Drehimpuls
lblErot=label(pos=vec(0.9,-1.12*r,0),text='<em>E</em><sub>rot</sub>  = 0 J') #Rotationsenergie
#Animationsschleife
t=w=0
while True:
    rate(20)
    if laeuft:
        f=sldF.value    #Drehfrequenz, Drehzahl
        w=2*pi*f        #Winkelgeschwindigkeit
        v=w*r           #Bahngeschwindigkeit
        Erot=1/2*J*w**2 #Rotationsenergie
        L=J*w
        seil.rotate(axis=vec(0,0,1),angle=w*dt,origin=vec(0,0,0))
        kugel.rotate(axis=vec(0,0,1),angle=w*dt,origin=vec(0,0,0))
        lblDrehimpuls.text= '<em>L</em> = %.2f Nms' %L #Drehimpuls
        lblW.text= '<em>\u03C9</em> = %.2f  1/s' %w    #Winkelgeschwindigkeit
        lblV.text= '<em>v</em> = %.2f m/s' %v          #Bahngeschwindigkeit
        lblErot.text= '<em>E</em><sub>rot</sub> = %.2f J' %Erot   #Rotationsenergie
        t=t+dt
        
        
'''
Daten zum Hammerwurf
Kreisdurchmesser: 2,135 m
Masse der Kugel: 7,26 kg
Abfluggeschwindigkeit: 28 m/s für eine Wurfweite von 74 m
Abwurfwinkel: 45°
'''